
IF NOT EXISTS(
	SELECT 
		1
	FROM 
		 sys.tables 
	WHERE 
		NAME = 'EST_PROD_TBL_DESC_EST_PROD_FABRIC' )
BEGIN
	SET ANSI_NULLS ON

	SET QUOTED_IDENTIFIER ON

	CREATE TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC](
		[CD_EMP] [int] NOT NULL,
		[CD_TBL_DESC] [int] NOT NULL,
		[CD_FABRIC] [int] NOT NULL,
		[PERC_DESC] [money] NOT NULL,
		[PERC_DESC_MAX] [money] NOT NULL,
		[PERC_DESC_LIMITE] [money] NOT NULL,
		[PERC_AUMENTO] [money] NOT NULL,
	 CONSTRAINT [PK_EST_PROD_TBL_DESC_EST_PROD_FABRIC] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_TBL_DESC] ASC,
		[CD_FABRIC] ASC
	)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
	) ON [PRIMARY]


	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_EST_PROD_FABRIC_EST_PROD_FABRIC] FOREIGN KEY([CD_FABRIC])
	REFERENCES [dbo].[EST_PROD_FABRIC] ([CD_FABRIC])
	ON UPDATE CASCADE

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_EST_PROD_FABRIC_EST_PROD_FABRIC]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_TBL_DESC_EST_PROD_FABRIC_EST_PROD_TBL_DESC] FOREIGN KEY([CD_EMP], [CD_TBL_DESC])
	REFERENCES [dbo].[EST_PROD_TBL_DESC] ([CD_EMP], [CD_TBL_DESC])
	ON UPDATE CASCADE
	ON DELETE CASCADE

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] CHECK CONSTRAINT [FK_EST_PROD_TBL_DESC_EST_PROD_FABRIC_EST_PROD_TBL_DESC]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_EST_PROD_FABRIC_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_EST_PROD_FABRIC_PERC_DESC_REC]  DEFAULT ((0)) FOR [PERC_DESC_MAX]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_EST_PROD_FABRIC_PERC_DESC_LIMITE]  DEFAULT ((0)) FOR [PERC_DESC_LIMITE]

	ALTER TABLE [dbo].[EST_PROD_TBL_DESC_EST_PROD_FABRIC] ADD  CONSTRAINT [DF_EST_PROD_TBL_DESC_EST_PROD_FABRIC_PERC_AUMENTO]  DEFAULT ((0)) FOR [PERC_AUMENTO]

END

